#pragma once

#define ROUND(x) ((x)>=0?(long)((x)+0.5):(long)((x)-0.5))
#define ROUND1(x) (ROUND(10*x)/10.0) //zaokraglenie z czescia dziesietna
#define ROUND2(x) (ROUND(100*x)/100.0) //zaokraglenie z setnymi

#define DI_MAX_LENGTH 256

struct DaneODysku
{
	char literaDysku;
	BOOL czyDyskDostepny;

	int typDysku;
	TCHAR typDyskuOpis[DI_MAX_LENGTH];

	unsigned __int64 calkowitaPrzestrzen;
	unsigned __int64 wolnaPrzestrzen;
	unsigned __int64 zajetaPrzestrzen;

	double wolnaPrzestrzenUlamek;
	unsigned char wolnaPrzestrzenProcenty;

	TCHAR nazwaDysku[DI_MAX_LENGTH];
	ULONG numerSeryjnyDysku;
	TCHAR nazwaFAT[DI_MAX_LENGTH];
	ULONG maksymalnaDlugoscPlikuLubKatalogu;

	ULONG maksymalnaDlugoscSciezki;
};

BOOL PobierzInformacjeODysku(char literaDysku, DaneODysku& diskInfo);

class InformacjeODysku : public DaneODysku
{
public:
	InformacjeODysku(char literaDysku='C')
	{
		this->literaDysku=literaDysku;
		PobierzInformacjeODysku(this->literaDysku,*this);
	}
};